/*
 * Decompiled with CFR 0.152.
 */
package logicsim;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import logicsim.App;
import logicsim.Gate;
import logicsim.GateList;
import logicsim.I18N;
import logicsim.LSFrame;
import logicsim.MODIN;
import logicsim.MODOUT;
import logicsim.Wire;

public class Module
extends Gate {
    static final long serialVersionUID = 3938879095465005332L;
    String fname;
    private transient MODIN ModIn = null;
    private transient MODOUT ModOut = null;
    transient GateList gates;
    transient boolean moduleLoaded = false;

    public Module(String string) {
        this.imagename = "module";
        this.fname = string;
        this.loadModule();
    }

    public void loadModule() {
        int n;
        Object object;
        try {
            InputStream inputStream = null;
            if (LSFrame.isApplet) {
                inputStream = new URL(LSFrame.applet.getCodeBase() + "modules/" + this.fname + ".mod").openStream();
            } else {
                object = new File(App.getModulePath() + this.fname + ".mod");
                if (!((File)object).exists()) {
                    String string = I18N.getString("ERROR_MODULENOTFOUND").replaceFirst("%s", this.fname);
                    JOptionPane.showMessageDialog(null, string);
                    return;
                }
                inputStream = new FileInputStream((File)object);
            }
            object = new ObjectInputStream(inputStream);
            this.gates = (GateList)((ObjectInputStream)object).readObject();
            ((ObjectInputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, I18N.getString("ERROR_FILENOTFOUND"));
        }
        catch (StreamCorruptedException streamCorruptedException) {
            JOptionPane.showMessageDialog(null, I18N.getString("ERROR_FILECORRUPTED"));
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, I18N.getString("ERROR_READ"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, I18N.getString("ERROR_CLASS"));
        }
        if (this.gates == null) {
            return;
        }
        this.gates.reconnect();
        for (n = 0; n < this.gates.size(); ++n) {
            object = this.gates.get(n);
            if (object instanceof MODIN) {
                this.ModIn = (MODIN)object;
            }
            if (!(object instanceof MODOUT)) continue;
            this.ModOut = (MODOUT)object;
        }
        if (this.ModIn == null || this.ModOut == null) {
            JOptionPane.showMessageDialog(null, I18N.getString("ERROR_NOMODULE"));
            return;
        }
        for (n = 0; n < 16; ++n) {
            this.ModIn.setInput(n, this.getInput(n));
        }
        this.moduleLoaded = true;
    }

    public void simulate() {
        for (int i = 0; i < 16; ++i) {
            this.ModIn.inputTypes[i] = this.inputTypes[i];
        }
        if (this.gates != null) {
            this.gates.simulate();
        }
    }

    public boolean getOutput(int n) {
        if (this.ModOut != null && n >= 0 && n < this.getNumOutput()) {
            return this.ModOut.getOutput(n);
        }
        return false;
    }

    public void setInput(int n, Wire wire) {
        super.setInput(n, wire);
        if (n >= 0 && n < 16) {
            this.ModIn.in.setElementAt(wire, n);
        }
    }

    public int getNumInput() {
        int n = 0;
        if (this.gates == null) {
            return 8;
        }
        for (int i = 0; i < this.gates.size(); ++i) {
            Gate gate = this.gates.get(i);
            if (gate instanceof MODIN) continue;
            for (int j = 0; j < gate.getNumInput(); ++j) {
                Wire wire = gate.getInput(j);
                if (wire == null || wire.gate != this.ModIn || wire.outNum <= n) continue;
                n = wire.outNum;
            }
        }
        return n + 1;
    }

    public int getNumOutput() {
        if (this.ModOut == null) {
            return 8;
        }
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            Wire wire = this.ModOut.getInput(i);
            if (wire == null) continue;
            n = i + 1;
        }
        return n;
    }

    public void loadImage() {
        Image image = null;
        String string = "images/din/";
        if (LSFrame.gatedesign.equals("iso")) {
            string = "images/iso/";
        }
        if ((image = new ImageIcon(LSFrame.class.getResource(string + this.imagename + ".gif")).getImage()) != null) {
            int n = image.getWidth(null);
            int n2 = this.getNumInput();
            if (this.getNumOutput() > n2) {
                n2 = this.getNumOutput();
            }
            if (n2 < 4) {
                n2 = 4;
            }
            int n3 = 10 + (n2 - 1) * 10;
            BufferedImage bufferedImage = new BufferedImage(n, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, n, 10, 0, 0, n, 10, null);
            for (int i = 0; i < n2 - 1; ++i) {
                graphics2D.drawImage(image, 0, 10 + i * 10, n, 10 + i * 10 + 10, 0, 10, n, 20, null);
            }
            graphics2D.drawImage(image, 0, n3 - 10, n, n3, 0, image.getHeight(null) - 10, n, image.getHeight(null), null);
            this.gateimage = bufferedImage;
            this.gateimagewidth = this.gateimage.getWidth(null);
            this.gateimageheight = this.gateimage.getHeight(null);
        }
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.ModIn != null) {
            graphics.setClip(this.x, this.y, this.gateimagewidth, this.gateimageheight);
            String string = new String(this.ModIn.ModuleLabel);
            graphics.setColor(Color.black);
            graphics.drawString(string, this.x + 7, this.y + 20);
            graphics.setClip(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    public boolean hasProperties() {
        return true;
    }

    public boolean showProperties(Component component) {
        if (this.ModIn != null) {
            JOptionPane.showMessageDialog(component, I18N.getString("MESSAGE_MODULE_NAME") + ": " + this.ModIn.ModuleName + "\n" + I18N.getString("MESSAGE_MODULE_DESCRIPTION") + ":\n" + this.ModIn.ModuleDescription);
        }
        return true;
    }

    public int getOutputPosition(int n) {
        return this.getConnectorPosition(n, this.getNumOutput());
    }

    public int getInputPosition(int n) {
        return this.getConnectorPosition(n, this.getNumInput());
    }

    public int getConnectorPosition(int n, int n2) {
        if (n2 == 0) {
            return -1;
        }
        return 5 + n * 10;
    }
}

