/*
 * Decompiled with CFR 0.152.
 */
package logicsim;

import java.awt.Component;
import java.util.Date;
import javax.swing.JOptionPane;
import logicsim.Gate;
import logicsim.I18N;

public class MonoFlop
extends Gate {
    static final long serialVersionUID = -6063406618533983926L;
    transient long startTime;
    transient boolean lastInputState;
    long highTime = 1000L;

    public MonoFlop() {
        this.imagename = "monoflop";
    }

    public int getNumInput() {
        return 1;
    }

    public int getNumOutput() {
        return 1;
    }

    public void simulate() {
        if (!this.lastInputState && this.getInput(0) != null && this.getInputState(0)) {
            this.out[0] = true;
            this.startTime = new Date().getTime();
        }
        if (new Date().getTime() - this.startTime > this.highTime) {
            this.out[0] = false;
        }
        if (this.getInput(0) != null) {
            this.lastInputState = this.getInputState(0);
        }
    }

    public boolean hasProperties() {
        return true;
    }

    public boolean showProperties(Component component) {
        String string = (String)JOptionPane.showInputDialog(component, I18N.getString("MESSAGE_ENTER_TIME_HIGH"), I18N.getString("GATE_MONOFLOP_PROPERTIES"), 3, null, null, Integer.toString((int)this.highTime));
        if (string != null && string.length() > 0) {
            this.highTime = new Integer(string).intValue();
        }
        return true;
    }
}

